<div class="box box-info">
    <div class="box-header with-border">
        <h3 class="box-title"><?php echo e(trans('admin.latestunapprovedposts')); ?></h3>
        <div class="box-tools pull-right">
            <button class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
            <button class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>
        </div>
    </div><!-- /.box-header -->
    <div class="box-body">
        <?php if(count($lastunappruves) !== 0): ?>
        <div class="table-responsive">
            <table class="table no-margin">
                <thead>
                    <tr>
                        <th width="5%"><?php echo e(trans('admin.thumb')); ?></th>
                        <th width="65%"><?php echo e(trans('admin.posts')); ?></th>
                        <th width="15%"><?php echo e(trans('admin.type')); ?></th>
                        <th width="15%"><?php echo e(trans('admin.actions')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $lastunappruves; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td>
                            <div class="product-img">
                                <img src="<?php echo e(makepreview($item->thumb, 's', 'posts')); ?>" width="50">
                            </div>
                        </td>
                        <td><a target="_blank" href="<?php echo e($item->post_link); ?>"><?php echo e($item->title); ?></a>
                        </td>
                        <td>
                            <?php if($item->type == 'news'): ?>
                            <span class="label  bg-aqua"><i class="fa fa-file-text"></i>&nbsp;<?php echo e(trans('admin.news')); ?></span>
                            <?php elseif($item->type == 'list'): ?>
                            <span class="label bg-green"><i class="fa fa-th-list"></i>&nbsp;<?php echo e(trans('admin.lists')); ?></span>
                            <?php elseif($item->type == 'quiz'): ?>
                            <span class="label bg-purple"><i class="fa fa-th-list"></i>&nbsp;<?php echo e(trans('admin.quizzes')); ?></span>
                            <?php elseif($item->type == 'poll'): ?>
                            <span class="label  bg-yellow"><i class="fa fa-check-square-o"></i>&nbsp;<?php echo e(trans('admin.polls')); ?></span>
                            <?php elseif($item->type == 'video'): ?>
                            <span class="label  bg-red"><i class="fa fa-youtube-play"></i>&nbsp;<?php echo e(trans('admin.videos')); ?></span>
                            <?php else: ?>
                            <?php endif; ?>
                        </td>
                        <td>
                            <div class="input-group-btn">
                                <button type="button" class="btn btn-default dropdown-toggle"
                                    data-toggle="dropdown" aria-expanded="false">
                                    <?php echo e(trans('admin.actions')); ?>

                                        <span class="fa fa-caret-down"></span>
                                </button>
                                <ul class="dropdown-menu pull-right">
                                    <li>
                                        <a href="<?php echo e(action('Admin\PostsController@bulkAction',  ['ids' => $item->id, 'action' => 'approve'])); ?>">
                                            <?php echo e(trans('admin.approvePost')); ?>

                                        </a>
                                    </li>
                                    <li class="divider"></li>
                                    <li>
                                        <a target=_blank href="<?php echo e(action('PostEditorController@showPostEdit', $item->id)); ?>">
                                            <?php echo e(trans('admin.editpost')); ?>

                                        </a>
                                    </li>
                                    <li class="divider"></li>
                                    <li>
                                        <a class="sendtrash" href="<?php echo e(action('Admin\PostsController@bulkAction', ['ids' => $item->id, 'action' => 'delete'])); ?>">
                                            <?php echo e(trans('admin.sendtrash')); ?>

                                        </a>
                                    </li>
                                    <li>
                                        <a class="permanently" href="<?php echo e(action('Admin\PostsController@bulkAction', ['ids' => $item->id, 'action' => 'forceDelete'])); ?>">
                                            <?php echo e(trans('admin.deletepermanently')); ?>

                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div><!-- /.table-responsive -->
        <?php else: ?>
        <?php echo e(trans('admin.nothingtoseehere')); ?>

        <?php endif; ?>
    </div><!-- /.box-body -->
    <div class="box-footer text-center">
        <a href="<?php echo e(route('admin.posts',  ['only' => 'unapprove'])); ?>" class="uppercase"><?php echo e(trans('admin.viewall')); ?></a>
    </div><!-- /.box-footer -->
</div>
<?php /**PATH /home/highaltitude/public_html/resources/views/_admin/_particles/dashboard/unapproved-posts.blade.php ENDPATH**/ ?>