<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title><?php echo e(get_buzzy_config('sitename')); ?> | <?php echo e(trans('admin.adminpanel')); ?></title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">

    <!-- Font Awesome -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/fontawesome.min.css')); ?>">
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
    <!-- Bootstrap 3.3.5 -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/adminlte/bootstrap/css/bootstrap.min.css')); ?>">
    <!-- Theme style -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/adminlte/dist/css/AdminLTE.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/adminlte/dist/css/skins/_all-skins.min.css')); ?>">

    <!-- sweetalert -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/adminlte/plugins/sweetalert/sweetalert.css')); ?>">

    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/admin.css')); ?>">

    <?php echo $__env->yieldContent('header'); ?>

    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
    <script src="<?php echo e(asset('assets/plugins/vendor/html5shiv.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/vendor/respond.min.js')); ?>"></script>
    <![endif]-->
</head>

<body class="hold-transition skin-blue sidebar-mini">
    <div class="wrapper">

        <?php echo $__env->make('_admin.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!-- Left side column. contains the logo and sidebar -->
        <aside class="main-sidebar">
            <!-- sidebar: style can be found in sidebar.less -->
            <?php echo $__env->make('_admin._particles.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <!-- /.sidebar -->
        </aside>

        <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">

            <?php echo $__env->make('_admin._particles.update-alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php echo $__env->make('errors.error', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php echo $__env->yieldContent("content"); ?>

        </div><!-- /.content-wrapper -->

        <?php echo $__env->make('_admin.layout.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    </div><!-- ./wrapper -->

    <!-- jQuery 2.1.4 -->
    <script src="<?php echo e(asset('assets/plugins/adminlte/plugins/jQuery/jQuery-2.1.4.min.js')); ?>"></script>
    <!-- jQuery UI 1.11.4 -->
    <script src="<?php echo e(asset('assets/plugins/adminlte/plugins/jQueryUI/jquery-ui.min.js')); ?>"></script>
    <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
    <!-- Bootstrap 3.3.5 -->
    <script src="<?php echo e(asset('assets/plugins/adminlte/bootstrap/js/bootstrap.min.js')); ?>"></script>
    <!-- SlimScroll 1.3.0 -->
    <script src="<?php echo e(asset('assets/plugins/adminlte/plugins/slimScroll/jquery.slimscroll.min.js')); ?>"></script>

    <!-- sweetalert -->
    <script src="<?php echo e(asset('assets/plugins/adminlte/plugins/sweetalert/sweetalert.min.js')); ?>"></script>

    <!-- AdminLTE App -->
    <script src="<?php echo e(asset('assets/plugins/adminlte/dist/js/adminlte.min.js')); ?>"></script>

    <script>
        var buzzy_item_id ="<?php echo e(config('buzzy.item_id')); ?>";
        var buzzy_base_url ="<?php echo e(route('home')); ?>";
        var buzzy_current_url ="<?php echo e(url()->current()); ?>";
        var buzzy_registered = <?php echo e($updates !== false ? '1' : '0'); ?>;
    </script>

    <?php echo $__env->yieldContent('footer_js'); ?>

    <script src="<?php echo e(asset('assets/admin/js/app.js?v='.config('buzzy.version'))); ?>"></script>

    <?php echo $__env->yieldContent('footer'); ?>

    <div class="hide">
        <input name="_requesttoken" id="requesttoken" type="hidden" value="<?php echo e(csrf_token()); ?>" />
    </div>

    <?php echo $__env->make('.errors.swalerror', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

</body>

</html>
<?php /**PATH /home/highaltitude/public_html/resources/views/_admin/adminapp.blade.php ENDPATH**/ ?>