<?php $__env->startSection("content"); ?>
<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>
        <?php echo e(trans('admin.Categories')); ?>

        <?php if(get_multilanguage_enabled()): ?>
        &nbsp;>&nbsp; <?php echo get_language_list(get_buzzy_locale()); ?>

        <?php endif; ?>
    </h1>
    </h1>
    <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> <?php echo e(trans('admin.dashboard')); ?></a></li>
        <li class="active"><?php echo e(trans('admin.Categories')); ?></li>
    </ol>
</section>
<section class="content">
    <div class="row">
        <div class="col-md-4">
            <?php echo $__env->make('_admin.pages.categories.particles._form', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div><!-- /.col -->

        <div class="col-md-8">
            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ci => $_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="nav-tabs-custom category-list">
                <ul class="nav nav-tabs pull-right">
                    <li class="pull-left header">
                        <i class="fa fa-<?php echo e(config('buzzy.post_types.' . $_category->type. '.icon')); ?>"></i>

                        <b><?php echo e($_category->name); ?></b>
                        <span>(<a href="<?php echo e(route('admin.posts',  ['type' => 'category', 'category_id' => $_category->id])); ?>"><?php echo e(__(':count Posts', ['count' => \App\Post::byCategories(get_category_all_childids_recursively($_category))->byApproved()->byPublished()->count()])); ?></a>)</span>

                        <?php if($_category->disabled === "1"): ?>
                        <span class="pull-right badge bg-red" data-toggle="tooltip"
                            data-original-title="Category Disabled">DISABLED</span>
                        <?php endif; ?>
                        <?php if(!array_key_exists($_category->type, get_post_types())): ?>
                        <span class="pull-right badge bg-red" data-toggle="tooltip"
                            data-original-title="Post type: <?php echo e($_category->type); ?> deactivated on Plugins. Users can't add <?php echo e($_category->type); ?> post type">Not available</span>
                        <?php endif; ?>
                    </li>
                    <li class="pull-right header">
                        <a href="<?php echo e(route('admin.categories', ['edit' => $_category->id])); ?>"
                            class="btn btn-sm btn-success" role="button"
                            data-toggle="tooltip" title="" data-original-title="<?php echo e(trans("admin.edit")); ?>"><i
                                class="fa fa-edit"></i>
                            <?php echo e(trans('admin.edit')); ?></a>
                        <a class="btn btn-sm btn-danger permanently"
                            href="<?php echo e(route('admin.category.delete', ['category' => $_category->id])); ?>" role="button" data-toggle="tooltip"
                            data-original-title="<?php echo e(trans("admin.delete")); ?>"><i class="fa fa-times"></i>
                            <?php echo e(trans('admin.delete')); ?></a>
                    </li>
                </ul>
                <div class="tab-content">
                    <div class="tab-pane active" id="tab_<?php echo e($ci); ?>-1">
                        <?php echo $__env->make('_admin.pages.categories.particles._list', ['altcategories' => $_category], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div><!-- /.tab-pane -->
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div><!-- /.col -->
    </div><!-- /.row -->
</section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection("footer"); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("_admin.adminapp", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/highaltitude/public_html/resources/views/_admin/pages/categories/index.blade.php ENDPATH**/ ?>