<?php $__env->startSection('head_title', $user->username . ' | ' . get_buzzy_config('sitename')); ?>
<?php $__env->startSection('body_class', 'mode-add user-profile'); ?>
<?php $__env->startSection('content'); ?>

<div class="wt-container">

    <div class="global-container container add-container">

        <div class="profile-splash">
            <div class="profile-splash-cov"></div>
            <img src="<?php echo e(makepreview($user->splash, 'b', 'members/splash')); ?>" width="100%" data-big=""
                alt="<?php echo e($user->username); ?>" class="profile-splash-img">
            <div class="profile-section">
                <a href="<?php echo e($user->profile_link); ?>"><img
                        src="<?php echo e(makepreview($user->icon, 'b', 'members/avatar')); ?>" width="180" height="180"
                        data-big="" alt="<?php echo e($user->username); ?>" class="profile-image"></a>
            </div>

            <div class="profile-display-name">
                <a href="<?php echo e($user->profile_link); ?>"><?php echo e($user->username); ?></a>
                <?php if($user->usertype == 'Admin'): ?>
                <div class="label label-admin"> <?php echo e(trans('updates.usertypeadmin')); ?></div>
                <?php elseif($user->usertype == 'Staff'): ?>
                <div class="label label-staff"> <?php echo e(trans('updates.usertypestaff')); ?></div>
                <?php elseif($user->usertype == 'banned'): ?>
                <div class="label label-banned"> <?php echo e(trans('updates.usertypebanned')); ?></div>
                <?php endif; ?>
            </div>

            <div class="following_area<?php echo e($user->id); ?> profile-follow">
                <?php echo $__env->make('._particles.user.follow_button', ['user' => $user], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php echo $__env->make('_particles.user.messages._usermessagebutton', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>

        <div class="profile-wrap">

            <div class="profile-content clearfix">

                <div class="profile-sidebar">

                    <div class="profile-section">

                        <div class="profile-details">
                            <?php if($user->name): ?>
                            <div class="profile-detail">
                                <strong><?php echo e(trans('index.usern')); ?></strong>
                                <?php echo e($user->name); ?>

                            </div>
                            <?php endif; ?>
                            <?php if($user->genre): ?>
                            <div class="profile-detail">
                                <strong><?php echo e(trans('index.gender')); ?></strong>
                                <?php echo e($user->genre); ?>

                            </div>
                            <?php endif; ?>
                            <?php if($user->town): ?>
                            <div class="profile-detail">
                                <strong><?php echo e(trans('index.location')); ?></strong>
                                <?php echo e($user->town); ?>

                            </div>
                            <?php endif; ?>
                        </div>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $user)): ?>
                        <a class="button button-blue button-full set-button"
                            href="<?php echo e(route('user.settings', ['user' => $user->username_slug])); ?>"><?php echo e(trans('index.settings')); ?></a>
                        <a class="button button-white button-full set-button"
                            href="<?php echo e(route('user.messages', ['user' => $user->username_slug])); ?>"><?php echo e(trans('v4.messages')); ?></a>
                        <?php endif; ?>

                    </div>
                    <div class="profile-section">
                        <?php if(get_buzzy_config('p_buzzynews') == 'on'): ?>
                        <?php ($newscount = $user->posts()->byType('news')->byLanguage()->byApproved()->count()); ?>
                        <div class="profile-stat">
                            <div class="profile-stat-label"> <i class="fa fa-file-text"></i> <span
                                    class="stat-text"><?php echo e(trans('index.total', ['type' => trans('index.news')])); ?></span>
                            </div> <span class="profile-stat-count"><?php echo e($newscount); ?> </span>
                        </div>
                        <?php endif; ?>
                        <?php if(get_buzzy_config('p_buzzylists') == 'on'): ?>
                        <?php ($listscount = $user->posts()->byType('list')->byLanguage()->byApproved()->count()); ?>
                        <div class="profile-stat">
                            <div class="profile-stat-label"> <i class="fa fa-th-list"></i> <span
                                    class="stat-text"><?php echo e(trans('index.total', ['type' => trans('index.lists')])); ?></span>
                            </div> <span class="profile-stat-count"><?php echo e($listscount); ?> </span>
                        </div>
                        <?php endif; ?>
                        <?php if(get_buzzy_config('p_buzzyquizzes') == 'on'): ?>
                        <?php ($quizzescount = $user->posts()->byType('quiz')->byLanguage()->byApproved()->count()); ?>
                        <div class="profile-stat">
                            <div class="profile-stat-label"> <i class="fa fa-question-circle"></i> <span
                                    class="stat-text"><?php echo e(trans('index.total', ['type' => trans('buzzyquiz.quizzes')])); ?></span>
                            </div> <span class="profile-stat-count"><?php echo e($quizzescount); ?> </span>
                        </div>
                        <?php endif; ?>
                        <?php if(get_buzzy_config('p_buzzypolls') == 'on'): ?>
                        <?php ($pollscount = $user->posts()->byType('poll')->byLanguage()->byApproved()->count()); ?>
                        <div class="profile-stat">
                            <div class="profile-stat-label"> <i class="fa fa-check-circle-o"></i> <span
                                    class="stat-text"><?php echo e(trans('index.total', ['type' => trans('index.polls')])); ?></span>
                            </div> <span class="profile-stat-count"><?php echo e($pollscount); ?> </span>
                        </div>
                        <?php endif; ?>
                        <?php if(get_buzzy_config('p_buzzyvideos') == 'on'): ?>
                        <?php ($videoscount = $user->posts()->byType('video')->byLanguage()->byApproved()->count()); ?>
                        <div class="profile-stat">
                            <div class="profile-stat-label"> <i class="fa fa-youtube-play"></i> <span
                                    class="stat-text"><?php echo e(trans('index.total', ['type' => trans('index.videos')])); ?></span>
                            </div> <span class="profile-stat-count"><?php echo e($videoscount); ?> </span>
                        </div>
                        <?php endif; ?>
                    </div>

                    <?php if($user->about): ?>
                    <div class="profile-section">
                        <div class="profile-sidebar-label">
                            <?php echo e(trans('index.about')); ?>

                        </div>
                        <p><?php echo e($user->about); ?></p>
                    </div>
                    <?php endif; ?>
                    <?php if($user->following()->count() > 0): ?>
                    <div class="profile-section follow-images">
                        <div class="profile-sidebar-label">
                            <?php echo e(trans('updates.following')); ?>


                            <a class="more_follow"
                                href="<?php echo e(route('user.following', ['user' => $user->username_slug])); ?>"><?php echo e(trans('updates.allfollow', ['count' => $user->following()->count()])); ?></a>
                        </div>
                        <?php $__currentLoopData = $user
                        ->following()
                        ->take(12)
                        ->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $following): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                        <a class="follow-image" href="<?php echo e($following->followed->profile_link); ?>"
                            title="<?php echo e($following->followed->username); ?>"><img
                                src="<?php echo e(makepreview($following->followed->icon, 's', 'members/avatar')); ?>" width="52"
                                height="52" alt="<?php echo e($following->followed->username); ?>"></a>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <?php endif; ?>
                    <?php if($user->followers()->count() > 0): ?>
                    <div class="profile-section follow-images">
                        <div class="profile-sidebar-label">
                            <?php echo e(trans('updates.followers')); ?>

                            <a class="more_follow" href="<?php echo e(route('user.followers', ['user' => $user->username_slug])); ?>">
                                <?php echo e(trans('updates.allfollow', ['count' => $user->followers()->count()])); ?></a>
                        </div>
                        <?php $__currentLoopData = $user
                        ->followers()
                        ->take(12)
                        ->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $follower): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                        <a class="follow-image" href="<?php echo e($follower->follower->profile_link); ?>"
                            title="<?php echo e($follower->follower->username); ?>"><img
                                src="<?php echo e(makepreview($follower->follower->icon, 's', 'members/avatar')); ?>" width="52"
                                height="52" alt="<?php echo e($follower->follower->username); ?>"></a>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <?php endif; ?>

                    <div class="profile-section">
                        <?php if($user->social_profiles): ?>
                            <?php echo $__env->make('_particles.user.social_profiles', ['social_profiles' => $user->social_profiles], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <br>
                        <?php endif; ?>
                        <?php echo trans('index.joinedat', ['time' => $user->created_at->diffForHumans()]); ?>

                    </div>

                </div>

                <div class="profile-main">
                    <?php echo $__env->yieldContent("usercontent"); ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("app", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/highaltitude/public_html/resources/views/pages/user/userapp.blade.php ENDPATH**/ ?>